//ys_drv_gfx_int035.h
//drv_gfx_generic.h
//INT035 Display Driver
//                      2017.8.15   by  YSDK Design
///////////////////////////////////////////////////////////////


#ifndef ys_DRV_GFX_GFX_INT035_H
#define ys_DRV_GFX_GFX_INT035_H

#include "gfx/hal/gfx.h"




//RS:  RG13    // Definitions for RS pin PIC32MZ
#define DisplayCmdDataConfig()      TRISGbits.TRISG13 = 0       //TRISGCLR = _TRISG_TRISG13_MASK
#define DisplaySetCommand()         LATGbits.LATG13 = 0         //LATGCLR = _LATG_LATG13_MASK
#define DisplaySetData()            LATGbits.LATG13 = 1         //LATGSET = _LATG_LATG13_MASK

//CS:  RG14     //Definitions for CS pin PIC32MZ   //
#define DisplayConfig()             TRISGbits.TRISG14 = 0       //TRISGCLR = _TRISG_TRISG14_MASK
#define DisplayEnable()             LATGbits.LATG14 = 0         //LATGCLR = _LATG_LATG14_MASK
#define DisplayDisable()            LATGbits.LATG14 = 1         //LATGSET = _LATG_LATG14_MASK


//RESET	RG12	// Definitions for reset pin PIC32MZ
#define DisplayResetToggle() PLIB_PORTS_PinToggle(PORTS_ID_0, PORT_CHANNEL_G, PORTS_BIT_POS_12)
#define DisplayResetOn() PLIB_PORTS_PinSet(PORTS_ID_0, PORT_CHANNEL_G, PORTS_BIT_POS_12)
#define DisplayResetOff() PLIB_PORTS_PinClear(PORTS_ID_0, PORT_CHANNEL_G, PORTS_BIT_POS_12)
#define DisplayResetStateGet() PLIB_PORTS_PinGetLatched(PORTS_ID_0, PORT_CHANNEL_G, PORTS_BIT_POS_12)
#define DisplayResetStateSet(Value) PLIB_PORTS_PinWrite(PORTS_ID_0, PORT_CHANNEL_G, PORTS_BIT_POS_12, Value)
    
// Functions for DisplayBacklight pin
#define DisplayBacklightToggle() 
#define DisplayBacklightOn() 
#define DisplayBacklightOff() 
#define DisplayBacklightStateGet() 
#define DisplayBacklightStateSet(Value) 




        
  
/*********************************************************************
* SSD1963 command table
*********************************************************************/
#define SSD1963_CMD_NOP                     0x00
#define SSD1963_CMD_SOFT_RESET              0x01
#define SSD1963_CMD_GET_PWR_MODE            0x0A
#define SSD1963_CMD_GET_ADDR_MODE           0x0B
#define SSD1963_CMD_GET_DISPLAY_MODE        0x0D
#define SSD1963_CMD_GET_TEAR_EFFECT_STATUS  0x0E
#define SSD1963_CMD_ENT_SLEEP               0x10
#define SSD1963_CMD_EXIT_SLEEP              0x11
#define SSD1963_CMD_ENT_PARTIAL_MODE        0x12
#define SSD1963_CMD_ENT_NORMAL_MODE         0x13
#define SSD1963_CMD_EXIT_INVERT_MODE        0x20
#define SSD1963_CMD_ENT_INVERT_MODE         0x21
#define SSD1963_CMD_SET_GAMMA               0x26
#define SSD1963_CMD_BLANK_DISPLAY           0x28
#define SSD1963_CMD_ON_DISPLAY              0x29
#define SSD1963_CMD_SET_COLUMN              0x2A
#define SSD1963_CMD_SET_PAGE                0x2B
#define SSD1963_CMD_WR_MEMSTART             0x2C
#define SSD1963_CMD_RD_MEMSTART             0x2E
#define SSD1963_CMD_SET_PARTIAL_AREA        0x30
#define SSD1963_CMD_SET_SCROLL_AREA         0x33
#define SSD1963_CMD_SET_TEAR_OFF            0x34
#define SSD1963_CMD_SET_TEAR_ON             0x35
#define SSD1963_CMD_SET_ADDR_MODE           0x36
#define SSD1963_CMD_SET_SCROLL_START        0x37
#define SSD1963_CMD_EXIT_IDLE_MODE          0x38
#define SSD1963_CMD_ENT_IDLE_MODE           0x39
#define SSD1963_CMD_WR_MEM_AUTO             0x3C
#define SSD1963_CMD_RD_MEM_AUTO             0x3E
#define SSD1963_CMD_SET_TEAR_SCANLINE       0x44
#define SSD1963_CMD_GET_SCANLINE            0x45
#define SSD1963_CMD_RD_DDB_START            0xA1
#define SSD1963_CMD_SET_PANEL_MODE          0xB0
#define SSD1963_CMD_GET_PANEL_MODE          0xB1
#define SSD1963_CMD_SET_HOR_PERIOD          0xB4
#define SSD1963_CMD_GET_HOR_PERIOD          0xB5
#define SSD1963_CMD_SET_VER_PERIOD          0xB6
#define SSD1963_CMD_GET_VER_PERIOD          0xB7
#define SSD1963_CMD_SET_GPIO_CONF           0xB8
#define SSD1963_CMD_GET_GPIO_CONF           0xB9
#define SSD1963_CMD_SET_GPIO_VAL            0xBA
#define SSD1963_CMD_GET_GPIO_STATUS         0xBB
#define SSD1963_CMD_SET_POST_PROC           0xBC
#define SSD1963_CMD_GET_POST_PROC           0xBD
#define SSD1963_CMD_SET_PWM_CONF            0xBE
#define SSD1963_CMD_GET_PWM_CONF            0xBF
#define SSD1963_CMD_SET_LCD_GEN0            0xC0
#define SSD1963_CMD_GET_LCD_GEN0            0xC1
#define SSD1963_CMD_SET_LCD_GEN1            0xC2
#define SSD1963_CMD_GET_LCD_GEN1            0xC3
#define SSD1963_CMD_SET_LCD_GEN2            0xC4
#define SSD1963_CMD_GET_LCD_GEN2            0xC5
#define SSD1963_CMD_SET_LCD_GEN3            0xC6
#define SSD1963_CMD_GET_LCD_GEN3            0xC7
#define SSD1963_CMD_SET_GPIO0_ROP           0xC8
#define SSD1963_CMD_GET_GPIO0_ROP           0xC9
#define SSD1963_CMD_SET_GPIO1_ROP           0xCA
#define SSD1963_CMD_GET_GPIO1_ROP           0xCB
#define SSD1963_CMD_SET_GPIO2_ROP           0xCC
#define SSD1963_CMD_GET_GPIO2_ROP           0xCD
#define SSD1963_CMD_SET_GPIO3_ROP           0xCE
#define SSD1963_CMD_GET_GPIO3_ROP           0xCF
#define SSD1963_CMD_SET_ABC_DBC_CONF        0xD0
#define SSD1963_CMD_GET_ABC_DBC_CONF        0xD1
#define SSD1963_CMD_SET_DBC_THRES           0xD4
#define SSD1963_CMD_GET_DBC_THRES           0xD5
#define SSD1963_CMD_PLL_START               0xE0
#define SSD1963_CMD_SET_PLL_MN              0xE2
#define SSD1963_CMD_GET_PLL_MN              0xE3
#define SSD1963_CMD_GET_PLL_STATUS          0xE4
#define SSD1963_CMD_ENT_DEEP_SLEEP          0xE5
#define SSD1963_CMD_SET_PCLK                0xE6
#define SSD1963_CMD_GET_PCLK                0xE7
#define SSD1963_CMD_SET_DATA_INTERFACE      0xF0
#define SSD1963_CMD_GET_DATA_INTERFACE      0xF1




#endif /* ys_DRV_GFX_INT035_H */